/*
 * Decompiled with CFR 0.152.
 */
package rpgboss.editor;

import com.typesafe.scalalogging.slf4j.LazyLogging;
import com.typesafe.scalalogging.slf4j.LazyLogging$class;
import com.typesafe.scalalogging.slf4j.Logger;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.swing.UIManager;
import rpgboss.editor.Internationalized$;
import rpgboss.editor.MainPanel;
import rpgboss.editor.VisibleConnection$;
import rpgboss.lib.Utils$;
import rpgboss.player.LwjglPlayer$;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.swing.MainFrame;
import scala.swing.SwingApplication;

public final class RpgDesktop$
extends SwingApplication
implements LazyLogging,
Thread.UncaughtExceptionHandler {
    public static final RpgDesktop$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new RpgDesktop$();
    }

    private Logger logger$lzycompute() {
        RpgDesktop$ rpgDesktop$ = this;
        synchronized (rpgDesktop$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public MainFrame top() {
        return new MainFrame(){
            private final MainPanel mainPanel;

            public MainPanel mainPanel() {
                return this.mainPanel;
            }

            public void closeOperation() {
                if (this.mainPanel().askSaveUnchanged()) {
                    super.closeOperation();
                }
                if (VisibleConnection$.MODULE$.currentSession() != null) {
                    VisibleConnection$.MODULE$.currentSession().close();
                }
            }
            {
                this.minimumSize_$eq(new Dimension(600, 400));
                this.resizable_$eq(false);
                this.centerOnScreen();
                this.title_$eq(Internationalized$.MODULE$.getMessage("rpgboss"));
                this.peer().setDefaultCloseOperation(0);
                this.mainPanel = new MainPanel(this);
                this.contents_$eq(this.mainPanel());
            }
        };
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error("Uncaught exception");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ex.printStackTrace();
    }

    public void handle(Throwable ex) {
        this.uncaughtException(Thread.currentThread(), ex);
    }

    @Override
    public void startup(String[] args2) {
        if (System.getProperty("swing.defaultlaf") == null) {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        BufferedImage icon = Utils$.MODULE$.readClasspathImage("icon.png");
        System.setProperty("sun.awt.exception.handler", "rpgboss.editor.EDTErrorHandler");
        Thread.setDefaultUncaughtExceptionHandler(this);
        MainFrame t = this.top();
        t.peer().setIconImage(icon);
        Dimension dimension = t.size();
        Dimension dimension2 = new Dimension(0, 0);
        Object object = !(dimension != null ? !((Object)dimension).equals(dimension2) : dimension2 != null) ? t.pack() : BoxedUnit.UNIT;
        t.visible_$eq(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void main(String[] args2) {
        if (Predef$.MODULE$.refArrayOps((Object[])args2).size() >= 2) {
            Object a = Predef$.MODULE$.refArrayOps((Object[])args2).head();
            String string2 = "--player";
            if (!(a != null ? !a.equals(string2) : string2 != null)) {
                LwjglPlayer$.MODULE$.main((String[])Predef$.MODULE$.refArrayOps((Object[])args2).tail());
                return;
            }
        }
        super.main(args2);
    }

    private RpgDesktop$() {
        MODULE$ = this;
        LazyLogging$class.$init$(this);
    }
}

